/*----------------------------------------------------------------------------*
 *
*******************************************************************************
*
* File:         pxreport.h
* Description:  
* Author:       Henrik Liebau
* Created:      05 Apr 2000, 09:24:07
* Modified:     Fri Apr  7 10:58:20 2000 by Henrik Liebau, BVS R&D
* Language:     C/C++ Include File
* Package:	PCI-X Protocol Permutator&Randomizer      
* Status:       
*
* (C) Copyright 2000 by Agilent Technologies, All Rights Reserved.
*
*******************************************************************************
*/
 
#ifndef __pxreport_H__
#define __pxreport_H__

/* include type definitions, if not already done */
#ifndef __pxrepdef_H__
#include <pxrepdef.h>
#endif /* defined __pxrepdef_H__ */

/* make sure this also runs in C++ programs */
#ifdef __cplusplus
extern "C" {
#endif

/*----------------------------------------------------------------------------*
 * BestXPprReportWrite 
 * CLI abbrev.: pprreportget
 *
 * retrieve PPR report for current settings 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT  BestXPprReportWrite (		/* @pprreportwrite */
  bx_handletype handle,				
  bx_charptrtype * reportStr				/* #RETURN "\"%s\"" */
  );

/*----------------------------------------------------------------------------*
 * BestXPprReportFile 
 * CLI abbrev.: pprreportfile file = <filename>
 *
 * generate file with PPR report for current settings 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT  BestXPprReportFile (		/* @pprreportfile */
  bx_handletype handle,
  bx_charptrtype filename				/* @file */
  );

/*----------------------------------------------------------------------------*
 * CLI bx_errtype EXPORT BestXPprReportDefaultSet (bx_handletype handle)
 * Purpose	:
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT BestXPprReportDefaultSet (    /* @pprreportdefaultset */
  bx_handletype handle
  );

/*----------------------------------------------------------------------------*
 * BestXPprReportSet 
 * CLI abbrev.: pprreportset prop=<reportprop> val = <value>
 *
 * Set PPR Report settings 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT  BestXPprReportSet (		/* @pprreportset */
  bx_handletype handle,
  bxppr_reporttype reportprop,				/* @prop */
  bx_int32 value					/* @val */
  );

/*----------------------------------------------------------------------------*
 * BestXPprReportGet 
 * CLI abbrev.: pprreportget prop=<reportprop>
 *
 * Get PPR Report settings 
 *---------------------------------------------------------------------------*/
CLI bx_errtype EXPORT  BestXPprReportGet (		/* @pprreportget */
  bx_handletype handle,
  bxppr_reporttype reportprop,				/* @prop */
  bx_int32 * pValue					/* #RETURN "%lu" */
  );

#ifdef PPRX_EXPORTS
/*****************************************************************************
 * ppr internal functions
 *****************************************************************************/

/*---------------------------------------------------------------------------*
 * bx_errtype PprReportPropData (
 *
 * Purpose	: 
 *---------------------------------------------------------------------------*/
bx_errtype PprReportPropData (
  bxppr_stringtype * resultStr,
  bxppr_propdatatype * propData,
  bx_int32 capi
  );
  
/*---------------------------------------------------------------------------*
 * bx_errtype PprReportVarList (
 *
 * Purpose	: 
 *---------------------------------------------------------------------------*/
bx_errtype PprReportVarList (
  bxppr_stringtype * resultStr,
  bxppr_vardatatype * varData,
  bxppr_resulttype * result,
  bx_int32 contents,
  bx_int32 capi
  );

/*---------------------------------------------------------------------------*
 * bx_errtype PprReportTableLine (bxppr_stringtype * pprString,
 *
 * Purpose	: 
 *---------------------------------------------------------------------------*/
bx_errtype PprReportTableLine (bxppr_stringtype * pprString,
			       bx_ccharptrtype entry,
			       bx_ccharptrtype option,
			       bx_ccharptrtype value);

#endif /* defined PPRX_EXPORTS */
  
#ifdef __cplusplus
}
#endif

#endif /* defined __pxreport_H__ */
